/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.metrics.api.Meter;

class MeterMetadata {
    private final String name;
    private final String description;
    private final String unit;

    static Builder builder() {
        return new Builder();
    }

    static MeterMetadata create(Meter meter) {
        return MeterMetadata.builder(meter).build();
    }

    static Builder builder(MeterMetadata meta) {
        return new Builder(meta);
    }

    static Builder builder(Meter meter) {
        return new Builder(meter);
    }

    private MeterMetadata(String name, String description, String unit) {
        this.name = name;
        this.description = description;
        this.unit = unit;
    }

    String name() {
        return this.name;
    }

    String description() {
        return this.description;
    }

    String unit() {
        return this.unit;
    }

    <B extends Meter.Builder<B, M>, M extends Meter> B apply(B builder) {
        if (this.name != null && !this.name.equals(builder.name())) {
            throw new IllegalArgumentException("name in Metadata.Builder '" + this.name + "' does not match name in Meter.Builder '" + builder.name() + "'");
        }
        if (this.description != null) {
            builder.description(this.description);
        }
        if (this.unit != null) {
            builder.baseUnit(this.unit);
        }
        return builder;
    }

    static class Builder
    implements io.helidon.common.Builder<Builder, MeterMetadata> {
        private String name;
        private String description;
        private String unit;

        Builder(MeterMetadata meta) {
            this.name = meta.name();
            this.description = meta.description();
            this.unit = meta.unit();
        }

        Builder(Meter meter) {
            this.name = meter.id().name();
            meter.description().ifPresent(d -> {
                this.description = d;
            });
            meter.baseUnit().ifPresent(u -> {
                this.unit = u;
            });
        }

        Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public MeterMetadata build() {
            return new MeterMetadata(this.name, this.description, this.unit);
        }
    }
}

