/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.dbclient.metrics.DbClientMetricBuilder;
import io.helidon.dbclient.metrics.MetricService;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;

final class MetricTimer
extends MetricService<Timer> {
    private MetricTimer(Builder builder) {
        super(builder);
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    protected void executeMetric(Timer metric, CompletionStage<Void> future) {
        long started = System.nanoTime();
        future.thenAccept(nothing -> {
            if (this.measureSuccess()) {
                this.update(metric, started);
            }
        }).exceptionally(throwable -> {
            if (this.measureErrors()) {
                this.update(metric, started);
            }
            return null;
        });
    }

    private void update(Timer metric, long started) {
        long delta = System.nanoTime() - started;
        metric.update(Duration.ofNanos(delta));
    }

    @Override
    protected String defaultNamePrefix() {
        return "db.timer.";
    }

    @Override
    protected Class<Timer> metricType() {
        return Timer.class;
    }

    @Override
    protected Timer metric(MetricRegistry registry, Metadata meta) {
        return registry.timer(meta);
    }

    static class Builder
    extends DbClientMetricBuilder<Builder, MetricTimer> {
        Builder() {
        }

        public MetricTimer build() {
            return new MetricTimer(this);
        }
    }
}

