/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.common.LazyValue;
import io.helidon.dbclient.DbClientServiceBase;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.metrics.MetricBuilderBase;
import io.helidon.metrics.api.RegistryFactory;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;

abstract class MetricService<T extends Metric>
extends DbClientServiceBase {
    private final Metadata meta;
    private final String description;
    private final BiFunction<String, DbStatementType, String> nameFunction;
    private final LazyValue<MetricRegistry> registry = LazyValue.create(() -> RegistryFactory.getInstance().getRegistry("application"));
    private final ConcurrentHashMap<String, T> cache = new ConcurrentHashMap();
    private final boolean measureErrors;
    private final boolean measureSuccess;

    protected MetricService(MetricBuilderBase<?, ?> builder) {
        super(builder);
        BiFunction<String, DbStatementType, String> nameFunction = builder.nameFormat();
        this.meta = builder.meta();
        if (null == nameFunction) {
            nameFunction = (name, statement) -> this.defaultNamePrefix() + name;
        }
        this.nameFunction = nameFunction;
        this.measureErrors = builder.errors();
        this.measureSuccess = builder.success();
        String tmpDescription = builder.description() == null ? (null == this.meta ? null : this.meta.getDescription()) : builder.description();
        this.description = tmpDescription;
    }

    protected abstract String defaultNamePrefix();

    protected DbClientServiceContext apply(DbClientServiceContext context) {
        DbStatementType dbStatementType = context.statementType();
        String statementName = context.statementName();
        Metric metric = this.cache.computeIfAbsent(statementName, s -> {
            MetadataBuilder builder;
            String name = this.nameFunction.apply(statementName, dbStatementType);
            MetadataBuilder metadataBuilder = builder = this.meta == null ? Metadata.builder().withName(name) : Metadata.builder((Metadata)this.meta);
            if (this.description != null) {
                builder = builder.withDescription(this.description);
            }
            return this.metric((MetricRegistry)this.registry.get(), builder.build());
        });
        this.executeMetric(metric, context.statementFuture());
        return context;
    }

    protected boolean measureErrors() {
        return this.measureErrors;
    }

    protected boolean measureSuccess() {
        return this.measureSuccess;
    }

    protected abstract void executeMetric(T var1, CompletionStage<Void> var2);

    protected abstract Class<? extends Metric> metricType();

    protected abstract T metric(MetricRegistry var1, Metadata var2);
}

