/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.dbclient.metrics.DbClientMetricBuilder;
import io.helidon.dbclient.metrics.MetricService;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;

final class MetricCounter
extends MetricService<Counter> {
    private MetricCounter(Builder builder) {
        super(builder);
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    protected void executeMetric(Counter metric, CompletionStage<Void> future) {
        future.thenRun(() -> {
            if (this.measureSuccess()) {
                metric.inc();
            }
        }).exceptionally(throwable -> {
            if (this.measureErrors()) {
                metric.inc();
            }
            return null;
        });
    }

    @Override
    protected Class<Counter> metricType() {
        return Counter.class;
    }

    @Override
    protected Counter metric(MetricRegistry registry, Metadata meta) {
        return registry.counter(meta);
    }

    @Override
    protected String defaultNamePrefix() {
        return "db.counter.";
    }

    static class Builder
    extends DbClientMetricBuilder<Builder, MetricCounter> {
        Builder() {
        }

        public MetricCounter build() {
            return new MetricCounter(this);
        }
    }
}

