/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.config.Config;
import io.helidon.dbclient.DbClientServiceBase;
import io.helidon.dbclient.DbStatementType;
import java.util.function.BiFunction;
import org.eclipse.microprofile.metrics.Metadata;

abstract class MetricBuilderBase<B extends MetricBuilderBase<B, T>, T extends DbClientServiceBase>
extends DbClientServiceBase.BuilderBase<B, T> {
    private Metadata meta;
    private BiFunction<String, DbStatementType, String> nameFormat;
    private boolean measureErrors = true;
    private boolean measureSuccess = true;
    private String description;

    MetricBuilderBase() {
    }

    public B name(String metricName) {
        this.nameFormat = (s, s2) -> metricName;
        return (B)((Object)((MetricBuilderBase)this.identity()));
    }

    public B metadata(Metadata meta) {
        this.meta = meta;
        return (B)((Object)((MetricBuilderBase)this.identity()));
    }

    public B nameFormat(String format) {
        return this.nameFormat((String name, DbStatementType queryType) -> String.format(format, queryType.toString(), name));
    }

    public B nameFormat(BiFunction<String, DbStatementType, String> function) {
        this.nameFormat = function;
        return (B)((Object)((MetricBuilderBase)this.identity()));
    }

    public B errors(boolean measureErrors) {
        this.measureErrors = measureErrors;
        return (B)((Object)((MetricBuilderBase)this.identity()));
    }

    public B success(boolean measureSuccess) {
        this.measureSuccess = measureSuccess;
        return (B)((Object)((MetricBuilderBase)this.identity()));
    }

    public B description(String description) {
        this.description = description;
        return (B)((Object)((MetricBuilderBase)this.identity()));
    }

    public B config(Config config) {
        super.config((io.helidon.common.config.Config)config);
        config.get("errors").asBoolean().ifPresent(this::errors);
        config.get("success").asBoolean().ifPresent(this::success);
        config.get("name-format").asString().ifPresent(this::nameFormat);
        config.get("description").asString().ifPresent(this::description);
        return (B)((Object)((MetricBuilderBase)this.identity()));
    }

    String description() {
        return this.description;
    }

    Metadata meta() {
        return this.meta;
    }

    BiFunction<String, DbStatementType, String> nameFormat() {
        return this.nameFormat;
    }

    boolean errors() {
        return this.measureErrors;
    }

    boolean success() {
        return this.measureSuccess;
    }
}

