/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.config.Config;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.common.DbClientServiceBase;
import java.util.function.BiFunction;
import org.eclipse.microprofile.metrics.Metadata;

abstract class DbClientMetricBuilderBase<T extends DbClientMetricBuilderBase<T>>
extends DbClientServiceBase.DbClientServiceBuilderBase<T> {
    private Metadata meta;
    private BiFunction<String, DbStatementType, String> nameFormat;
    private boolean measureErrors = true;
    private boolean measureSuccess = true;
    private String description;

    DbClientMetricBuilderBase() {
    }

    public T name(String metricName) {
        this.nameFormat = (s, s2) -> metricName;
        return this.me();
    }

    public T metadata(Metadata meta) {
        this.meta = meta;
        return this.me();
    }

    public T nameFormat(String format) {
        return this.nameFormat((String name, DbStatementType queryType) -> String.format(format, queryType.toString(), name));
    }

    public T nameFormat(BiFunction<String, DbStatementType, String> function) {
        this.nameFormat = function;
        return this.me();
    }

    public T errors(boolean measureErrors) {
        this.measureErrors = measureErrors;
        return this.me();
    }

    public T success(boolean measureSuccess) {
        this.measureSuccess = measureSuccess;
        return this.me();
    }

    public T description(String description) {
        this.description = description;
        return this.me();
    }

    public T config(Config config) {
        super.config(config);
        config.get("errors").asBoolean().ifPresent(this::errors);
        config.get("success").asBoolean().ifPresent(this::success);
        config.get("name-format").asString().ifPresent(this::nameFormat);
        config.get("description").asString().ifPresent(this::description);
        return this.me();
    }

    String description() {
        return this.description;
    }

    T me() {
        return (T)((Object)this);
    }

    Metadata meta() {
        return this.meta;
    }

    BiFunction<String, DbStatementType, String> nameFormat() {
        return this.nameFormat;
    }

    boolean errors() {
        return this.measureErrors;
    }

    boolean success() {
        return this.measureSuccess;
    }
}

