/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.dbclient.metrics.DbClientMetric;
import io.helidon.dbclient.metrics.DbClientMetricBuilder;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

final class DbClientMeter
extends DbClientMetric<Meter> {
    private DbClientMeter(Builder builder) {
        super(builder);
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    protected void executeMetric(Meter metric, CompletionStage<Void> aFuture) {
        aFuture.thenAccept(nothing -> {
            if (this.measureSuccess()) {
                metric.mark();
            }
        }).exceptionally(throwable -> {
            if (this.measureErrors()) {
                metric.mark();
            }
            return null;
        });
    }

    @Override
    protected MetricType metricType() {
        return MetricType.METERED;
    }

    @Override
    protected Meter metric(MetricRegistry registry, Metadata meta) {
        return registry.meter(meta);
    }

    @Override
    protected String defaultNamePrefix() {
        return "db.meter.";
    }

    static class Builder
    extends DbClientMetricBuilder {
        Builder() {
        }

        public DbClientMeter build() {
            return new DbClientMeter(this);
        }
    }
}

