/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.dbclient.metrics.DbClientMetric;
import io.helidon.dbclient.metrics.DbClientMetricBuilder;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;

final class DbClientTimer
extends DbClientMetric<Timer> {
    private DbClientTimer(Builder builder) {
        super(builder);
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    protected void executeMetric(Timer metric, CompletionStage<Void> aFuture) {
        long started = System.nanoTime();
        aFuture.thenAccept(nothing -> {
            if (this.measureSuccess()) {
                this.update(metric, started);
            }
        }).exceptionally(throwable -> {
            if (this.measureErrors()) {
                this.update(metric, started);
            }
            return null;
        });
    }

    private void update(Timer metric, long started) {
        long delta = System.nanoTime() - started;
        metric.update(delta, TimeUnit.NANOSECONDS);
    }

    @Override
    protected String defaultNamePrefix() {
        return "db.timer.";
    }

    @Override
    protected MetricType metricType() {
        return MetricType.TIMER;
    }

    @Override
    protected Timer metric(MetricRegistry registry, Metadata meta) {
        return registry.timer(meta);
    }

    static class Builder
    extends DbClientMetricBuilder {
        Builder() {
        }

        public DbClientTimer build() {
            return new DbClientTimer(this);
        }
    }
}

