/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.dbclient.DbClientService;
import io.helidon.dbclient.metrics.DbClientMetric;
import io.helidon.dbclient.metrics.DbClientMetricBuilder;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

final class DbClientCounter
extends DbClientMetric<Counter> {
    private DbClientCounter(Builder builder) {
        super(builder);
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    protected void executeMetric(Counter metric, CompletionStage<Void> aFuture) {
        aFuture.thenRun(() -> {
            if (this.measureSuccess()) {
                metric.inc();
            }
        }).exceptionally(throwable -> {
            if (this.measureErrors()) {
                metric.inc();
            }
            return null;
        });
    }

    @Override
    protected MetricType metricType() {
        return MetricType.COUNTER;
    }

    @Override
    protected Counter metric(MetricRegistry registry, Metadata meta) {
        return registry.counter(meta);
    }

    @Override
    protected String defaultNamePrefix() {
        return "db.counter.";
    }

    static class Builder
    extends DbClientMetricBuilder {
        Builder() {
        }

        public DbClientService build() {
            return new DbClientCounter(this);
        }
    }
}

