/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.config.Config;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbClientService;
import io.helidon.dbclient.metrics.DbClientMetricBuilder;
import io.helidon.dbclient.metrics.DbClientMetrics;
import io.helidon.dbclient.spi.DbClientServiceProvider;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class DbClientMetricsProvider
implements DbClientServiceProvider {
    private static final Logger LOGGER = Logger.getLogger(DbClientMetricsProvider.class.getName());

    public String configKey() {
        return "metrics";
    }

    public Collection<DbClientService> create(Config config) {
        List metricConfigs = (List)config.asNodeList().orElseGet(List::of);
        LinkedList<DbClientService> result = new LinkedList<DbClientService>();
        for (Config metricConfig : metricConfigs) {
            result.add(this.fromConfig(metricConfig));
        }
        if (result.isEmpty()) {
            LOGGER.info("DB Client metrics are enabled, yet none are configured in config.");
        }
        return result;
    }

    private DbClientService fromConfig(Config config) {
        String type;
        switch (type = (String)config.get("type").asString().orElse((Object)"COUNTER")) {
            case "COUNTER": {
                return (DbClientService)((DbClientMetricBuilder)DbClientMetrics.counter().config(config)).build();
            }
            case "METER": {
                return (DbClientService)((DbClientMetricBuilder)DbClientMetrics.meter().config(config)).build();
            }
            case "TIMER": {
                return (DbClientService)((DbClientMetricBuilder)DbClientMetrics.timer().config(config)).build();
            }
        }
        throw new DbClientException("Metrics type " + type + " is not supported through service loader");
    }
}

