/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.common.reactive.Single;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.common.DbClientServiceBase;
import io.helidon.dbclient.metrics.DbClientMetricBuilderBase;
import io.helidon.metrics.RegistryFactory;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

abstract class DbClientMetric<T extends Metric>
extends DbClientServiceBase {
    private final Metadata meta;
    private final String description;
    private final BiFunction<String, DbStatementType, String> nameFunction;
    private final MetricRegistry registry;
    private final ConcurrentHashMap<String, T> cache = new ConcurrentHashMap();
    private final boolean measureErrors;
    private final boolean measureSuccess;

    protected DbClientMetric(DbClientMetricBuilderBase<?> builder) {
        super(builder);
        BiFunction<String, DbStatementType, String> nameFunction = builder.nameFormat();
        this.meta = builder.meta();
        if (null == nameFunction) {
            nameFunction = (name, statement) -> this.defaultNamePrefix() + name;
        }
        this.nameFunction = nameFunction;
        this.registry = RegistryFactory.getInstance().getRegistry(MetricRegistry.Type.APPLICATION);
        this.measureErrors = builder.errors();
        this.measureSuccess = builder.success();
        String tmpDescription = builder.description() == null ? (null == this.meta ? null : (String)this.meta.getDescription().orElse(null)) : builder.description();
        this.description = tmpDescription;
    }

    protected abstract String defaultNamePrefix();

    protected Single<DbClientServiceContext> apply(DbClientServiceContext context) {
        DbStatementType dbStatementType = context.statementType();
        String statementName = context.statementName();
        Metric metric = this.cache.computeIfAbsent(statementName, s -> {
            MetadataBuilder builder;
            String name = this.nameFunction.apply(statementName, dbStatementType);
            MetadataBuilder metadataBuilder = builder = this.meta == null ? Metadata.builder().withName(name).withType(this.metricType()) : Metadata.builder((Metadata)this.meta);
            if (this.description != null) {
                builder = builder.withDescription(this.description);
            }
            return this.metric(this.registry, builder.build());
        });
        this.executeMetric(metric, context.statementFuture());
        return Single.just((Object)context);
    }

    protected boolean measureErrors() {
        return this.measureErrors;
    }

    protected boolean measureSuccess() {
        return this.measureSuccess;
    }

    protected abstract void executeMetric(T var1, CompletionStage<Void> var2);

    protected abstract MetricType metricType();

    protected abstract T metric(MetricRegistry var1, Metadata var2);
}

