/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.config.Config;
import io.helidon.dbclient.metrics.DbMetric;
import io.helidon.dbclient.metrics.DbMetricBuilder;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;

public final class DbTimer
extends DbMetric<Timer> {
    private DbTimer(Builder builder) {
        super(builder);
    }

    public static DbTimer create(Config config) {
        return ((Builder)DbTimer.builder().config(config)).build();
    }

    public static DbTimer create() {
        return DbTimer.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void executeMetric(Timer metric, CompletionStage<Void> aFuture) {
        long started = System.nanoTime();
        aFuture.thenAccept(nothing -> {
            if (this.measureSuccess()) {
                this.update(metric, started);
            }
        }).exceptionally(throwable -> {
            if (this.measureErrors()) {
                this.update(metric, started);
            }
            return null;
        });
    }

    private void update(Timer metric, long started) {
        long delta = System.nanoTime() - started;
        metric.update(delta, TimeUnit.NANOSECONDS);
    }

    @Override
    protected String defaultNamePrefix() {
        return "db.timer.";
    }

    @Override
    protected MetricType metricType() {
        return MetricType.COUNTER;
    }

    @Override
    protected Timer metric(MetricRegistry registry, Metadata meta) {
        return registry.timer(meta);
    }

    public static class Builder
    extends DbMetricBuilder<Builder>
    implements io.helidon.common.Builder<DbTimer> {
        public DbTimer build() {
            return new DbTimer(this);
        }
    }
}

