/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.config.Config;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbInterceptor;
import io.helidon.dbclient.metrics.DbCounter;
import io.helidon.dbclient.metrics.DbMeter;
import io.helidon.dbclient.metrics.DbTimer;
import io.helidon.dbclient.spi.DbInterceptorProvider;

public class DbMetricsProvider
implements DbInterceptorProvider {
    public String configKey() {
        return "metrics";
    }

    public DbInterceptor create(Config config) {
        String type;
        switch (type = (String)config.get("type").asString().orElse((Object)"COUNTER")) {
            case "COUNTER": {
                return DbCounter.create(config);
            }
            case "METER": {
                return DbMeter.create(config);
            }
            case "TIMER": {
                return DbTimer.create(config);
            }
        }
        throw new DbClientException("Metrics type " + type + " is not supported through service loader");
    }
}

