/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.config.Config;
import io.helidon.dbclient.DbStatementType;
import java.util.function.BiFunction;
import org.eclipse.microprofile.metrics.Metadata;

public abstract class DbMetricBuilder<T extends DbMetricBuilder<T>> {
    private Metadata meta;
    private BiFunction<String, DbStatementType, String> nameFormat;
    private boolean measureErrors = true;
    private boolean measureSuccess = true;
    private String description;

    public T name(String metricName) {
        this.nameFormat = (s, s2) -> metricName;
        return this.me();
    }

    public T metadata(Metadata meta) {
        this.meta = meta;
        return this.me();
    }

    public T nameFormat(String format) {
        return this.nameFormat((String name, DbStatementType queryType) -> String.format(format, name, queryType.toString()));
    }

    public T nameFormat(BiFunction<String, DbStatementType, String> function) {
        this.nameFormat = function;
        return this.me();
    }

    public T measureErrors(boolean shouldWe) {
        this.measureErrors = shouldWe;
        return this.me();
    }

    public T measureSuccess(boolean shouldWe) {
        this.measureSuccess = shouldWe;
        return this.me();
    }

    public T description(String description) {
        this.description = description;
        return this.me();
    }

    public T config(Config config) {
        config.get("errors").asBoolean().ifPresent(this::measureErrors);
        config.get("success").asBoolean().ifPresent(this::measureSuccess);
        config.get("name-format").asString().ifPresent(this::nameFormat);
        config.get("description").asString().ifPresent(this::description);
        return this.me();
    }

    String description() {
        return this.description;
    }

    T me() {
        return (T)this;
    }

    Metadata meta() {
        return this.meta;
    }

    BiFunction<String, DbStatementType, String> nameFormat() {
        return this.nameFormat;
    }

    boolean measureErrors() {
        return this.measureErrors;
    }

    boolean measureSuccess() {
        return this.measureSuccess;
    }

    static {
        HelidonFeatures.register((HelidonFlavor)HelidonFlavor.SE, (String[])new String[]{"DbClient", "Metrics"});
    }
}

