/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.config.Config;
import io.helidon.dbclient.metrics.DbMetric;
import io.helidon.dbclient.metrics.DbMetricBuilder;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

public final class DbMeter
extends DbMetric<Meter> {
    private DbMeter(Builder builder) {
        super(builder);
    }

    public static DbMeter create(Config config) {
        return ((Builder)DbMeter.builder().config(config)).build();
    }

    public static DbMeter create() {
        return DbMeter.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void executeMetric(Meter metric, CompletionStage<Void> aFuture) {
        aFuture.thenAccept(nothing -> {
            if (this.measureSuccess()) {
                metric.mark();
            }
        }).exceptionally(throwable -> {
            if (this.measureErrors()) {
                metric.mark();
            }
            return null;
        });
    }

    @Override
    protected MetricType metricType() {
        return MetricType.COUNTER;
    }

    @Override
    protected Meter metric(MetricRegistry registry, Metadata meta) {
        return registry.meter(meta);
    }

    @Override
    protected String defaultNamePrefix() {
        return "db.meter.";
    }

    public static class Builder
    extends DbMetricBuilder<Builder>
    implements io.helidon.common.Builder<DbMeter> {
        public DbMeter build() {
            return new DbMeter(this);
        }
    }
}

