/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.config.Config;
import io.helidon.dbclient.metrics.DbMetric;
import io.helidon.dbclient.metrics.DbMetricBuilder;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

public final class DbCounter
extends DbMetric<Counter> {
    private DbCounter(Builder builder) {
        super(builder);
    }

    public static DbCounter create(Config config) {
        return ((Builder)DbCounter.builder().config(config)).build();
    }

    public static DbCounter create() {
        return DbCounter.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void executeMetric(Counter metric, CompletionStage<Void> aFuture) {
        aFuture.thenAccept(nothing -> {
            if (this.measureSuccess()) {
                metric.inc();
            }
        }).exceptionally(throwable -> {
            if (this.measureErrors()) {
                metric.inc();
            }
            return null;
        });
    }

    @Override
    protected MetricType metricType() {
        return MetricType.COUNTER;
    }

    @Override
    protected Counter metric(MetricRegistry registry, Metadata meta) {
        return registry.counter(meta);
    }

    @Override
    protected String defaultNamePrefix() {
        return "db.counter.";
    }

    public static class Builder
    extends DbMetricBuilder<Builder>
    implements io.helidon.common.Builder<DbCounter> {
        public DbCounter build() {
            return new DbCounter(this);
        }
    }
}

