/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.dbclient.DbInterceptor;
import io.helidon.dbclient.DbInterceptorContext;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.metrics.DbMetricBuilder;
import io.helidon.metrics.RegistryFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

abstract class DbMetric<T extends Metric>
implements DbInterceptor {
    private final Metadata meta;
    private final String description;
    private final BiFunction<String, DbStatementType, String> nameFunction;
    private final MetricRegistry registry;
    private final ConcurrentHashMap<String, T> cache = new ConcurrentHashMap();
    private final boolean measureErrors;
    private final boolean measureSuccess;

    protected DbMetric(DbMetricBuilder<?> builder) {
        BiFunction<String, DbStatementType, String> namedFunction = builder.nameFormat();
        this.meta = builder.meta();
        if (null == namedFunction) {
            namedFunction = (name, statement) -> this.defaultNamePrefix() + name;
        }
        this.nameFunction = namedFunction;
        this.registry = RegistryFactory.getInstance().getRegistry(MetricRegistry.Type.APPLICATION);
        this.measureErrors = builder.measureErrors();
        this.measureSuccess = builder.measureSuccess();
        String tmpDescription = builder.description() == null ? (null == this.meta ? null : (String)this.meta.getDescription().orElse(null)) : builder.description();
        this.description = tmpDescription;
    }

    protected abstract String defaultNamePrefix();

    public CompletableFuture<DbInterceptorContext> statement(DbInterceptorContext interceptorContext) {
        DbStatementType dbStatementType = interceptorContext.statementType();
        String statementName = interceptorContext.statementName();
        Metric metric = this.cache.computeIfAbsent(statementName, s -> {
            MetadataBuilder builder;
            String name = this.nameFunction.apply(statementName, dbStatementType);
            MetadataBuilder metadataBuilder = builder = this.meta == null ? Metadata.builder().withName(name).withType(this.metricType()) : Metadata.builder((Metadata)this.meta);
            if (this.description != null) {
                builder = builder.withDescription(this.description);
            }
            return this.metric(this.registry, builder.build());
        });
        this.executeMetric(metric, interceptorContext.statementFuture());
        return CompletableFuture.completedFuture(interceptorContext);
    }

    protected boolean measureErrors() {
        return this.measureErrors;
    }

    protected boolean measureSuccess() {
        return this.measureSuccess;
    }

    protected abstract void executeMetric(T var1, CompletionStage<Void> var2);

    protected abstract MetricType metricType();

    protected abstract T metric(MetricRegistry var1, Metadata var2);
}

