/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics.jdbc;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;
import io.helidon.common.LazyValue;
import io.helidon.config.Config;
import io.helidon.dbclient.metrics.jdbc.JdbcMetricsCounter;
import io.helidon.dbclient.metrics.jdbc.JdbcMetricsGauge;
import io.helidon.dbclient.metrics.jdbc.JdbcMetricsHistogram;
import io.helidon.dbclient.metrics.jdbc.JdbcMetricsMeter;
import io.helidon.dbclient.metrics.jdbc.JdbcMetricsTimer;
import io.helidon.metrics.api.RegistryFactory;
import java.util.logging.Logger;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class DropwizardMetricsListener
implements MetricRegistryListener {
    private static final Logger LOGGER = Logger.getLogger(DropwizardMetricsListener.class.getName());
    private final String prefix;
    private final LazyValue<MetricRegistry> registry = LazyValue.create(() -> RegistryFactory.getInstance().getRegistry(MetricRegistry.Type.VENDOR));

    private DropwizardMetricsListener(String prefix) {
        this.prefix = prefix;
    }

    static MetricRegistryListener create(Config config) {
        return new DropwizardMetricsListener((String)config.get("name-prefix").asString().orElse((Object)"db.pool."));
    }

    public void onGaugeAdded(String name, Gauge<?> gauge) {
        LOGGER.finest(() -> String.format("Gauge added: %s", name));
        ((MetricRegistry)this.registry.get()).register(this.prefix + name, new JdbcMetricsGauge(gauge));
    }

    public void onGaugeRemoved(String name) {
        LOGGER.finest(() -> String.format("Gauge removed: %s", name));
        ((MetricRegistry)this.registry.get()).remove(this.prefix + name);
    }

    public void onCounterAdded(String name, Counter counter) {
        LOGGER.finest(() -> String.format("Counter added: %s", name));
        ((MetricRegistry)this.registry.get()).register(this.prefix + name, (Metric)new JdbcMetricsCounter(counter));
    }

    public void onCounterRemoved(String name) {
        LOGGER.finest(() -> String.format("Counter removed: %s", name));
        ((MetricRegistry)this.registry.get()).remove(this.prefix + name);
    }

    public void onHistogramAdded(String name, Histogram histogram) {
        LOGGER.finest(() -> String.format("Histogram added: %s", name));
        ((MetricRegistry)this.registry.get()).register(this.prefix + name, (Metric)new JdbcMetricsHistogram(histogram));
    }

    public void onHistogramRemoved(String name) {
        LOGGER.finest(() -> String.format("Histogram removed: %s", name));
        ((MetricRegistry)this.registry.get()).remove(this.prefix + name);
    }

    public void onMeterAdded(String name, Meter meter) {
        LOGGER.finest(() -> String.format("Meter added: %s", name));
        ((MetricRegistry)this.registry.get()).register(this.prefix + name, (Metric)new JdbcMetricsMeter(meter));
    }

    public void onMeterRemoved(String name) {
        LOGGER.finest(() -> String.format("Meter removed: %s", name));
        ((MetricRegistry)this.registry.get()).remove(this.prefix + name);
    }

    public void onTimerAdded(String name, Timer timer) {
        LOGGER.finest(() -> String.format("Timer added: %s", name));
        ((MetricRegistry)this.registry.get()).register(this.prefix + name, (Metric)new JdbcMetricsTimer(timer));
    }

    public void onTimerRemoved(String name) {
        LOGGER.finest(() -> String.format("Timer removed: %s", name));
        ((MetricRegistry)this.registry.get()).remove(this.prefix + name);
    }
}

