/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics.jdbc;

import io.helidon.dbclient.metrics.jdbc.JdbcMetricsSnapshot;
import io.helidon.dbclient.metrics.jdbc.JdbcMetricsTimerContext;
import java.time.Duration;
import java.util.concurrent.Callable;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

public class JdbcMetricsTimer
implements Timer {
    private final com.codahale.metrics.Timer meter;
    private long elapsedTimeNanos;

    JdbcMetricsTimer(com.codahale.metrics.Timer meter) {
        this.meter = meter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long start = System.nanoTime();
        try {
            Object object = this.meter.time(event);
            return (T)object;
        }
        finally {
            this.updateElapsedWithStart(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time(Runnable event) {
        long start = System.nanoTime();
        try {
            this.meter.time(event);
        }
        finally {
            this.updateElapsedWithStart(start);
        }
    }

    public Timer.Context time() {
        return new JdbcMetricsTimerContext(this.meter.time(), this::updateElapsed);
    }

    public long getCount() {
        return this.meter.getCount();
    }

    public double getFifteenMinuteRate() {
        return this.meter.getFifteenMinuteRate();
    }

    public double getFiveMinuteRate() {
        return this.meter.getFiveMinuteRate();
    }

    public double getMeanRate() {
        return this.meter.getMeanRate();
    }

    public double getOneMinuteRate() {
        return this.meter.getOneMinuteRate();
    }

    public Snapshot getSnapshot() {
        return new JdbcMetricsSnapshot(this.meter.getSnapshot());
    }

    public void update(Duration duration) {
        this.updateElapsed(duration.toNanos());
        this.meter.update(duration);
    }

    public Duration getElapsedTime() {
        return Duration.ofNanos(this.elapsedTimeNanos);
    }

    private long updateElapsed(long delta) {
        this.elapsedTimeNanos += delta;
        return delta;
    }

    private long updateElapsedWithStart(long start) {
        return this.updateElapsed(System.nanoTime() - start);
    }
}

