/*
 * Copyright (c) 2019, 2023 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import io.helidon.common.features.api.Feature;
import io.helidon.common.features.api.HelidonFlavor;

/**
 * Hikari Connection Pool Metrics.
 */
@Feature(value = "Hikari Connection Pool Metrics",
         description = "Hikari connection pool metrics support",
         in = HelidonFlavor.SE,
         path = {"DbClient", "Metrics-Hikari"}
)
module helidon.dbclient.metrics.hikari {

    requires transitive io.helidon.common.features.api;

    requires transitive io.helidon.common.config;
    requires transitive io.helidon.metrics.api;
    requires transitive io.helidon.dbclient.jdbc;
    requires transitive io.helidon.dbclient.hikari;

    requires com.codahale.metrics;

    provides io.helidon.dbclient.hikari.spi.HikariMetricsProvider
            with io.helidon.dbclient.metrics.hikari.HikariMetricsExtensionProvider;

}
