/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jsonp;

import io.helidon.dbclient.DbMapper;
import io.helidon.dbclient.DbRow;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class JsonProcessingMapper
implements DbMapper<JsonObject> {
    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private static final Map<Class<?>, DbJsonWriter> JSON_WRITERS = new IdentityHashMap();
    private static final DbJsonWriter NUMBER_WRITER = (builder, name, value) -> builder.add(name, ((Number)value).longValue());
    private static final DbJsonWriter OBJECT_WRITER = (builder, name, value) -> builder.add(name, String.valueOf(value));

    private JsonProcessingMapper() {
    }

    public static JsonProcessingMapper create() {
        return new JsonProcessingMapper();
    }

    public JsonObject read(DbRow row) {
        JsonObjectBuilder objectBuilder = JSON.createObjectBuilder();
        row.forEach(dbCol -> this.toJson(objectBuilder, dbCol.name(), dbCol.javaType(), dbCol.get()));
        return objectBuilder.build();
    }

    public Map<String, Object> toNamedParameters(JsonObject value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        value.forEach((name, json) -> result.put((String)name, this.toObject((String)name, (JsonValue)json, value)));
        return result;
    }

    public List<Object> toIndexedParameters(JsonObject value) {
        LinkedList<Object> result = new LinkedList<Object>();
        value.forEach((name, json) -> result.add(this.toObject((String)name, (JsonValue)json, value)));
        return result;
    }

    private void toJson(JsonObjectBuilder objectBuilder, String name, Class<?> valueClass, Object value) {
        if (value == null) {
            objectBuilder.addNull(name);
        }
        this.getJsonWriter(valueClass).write(objectBuilder, name, value);
    }

    private DbJsonWriter getJsonWriter(Class<?> valueClass) {
        DbJsonWriter writer = JSON_WRITERS.get(valueClass);
        if (null != writer) {
            return writer;
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            return NUMBER_WRITER;
        }
        return OBJECT_WRITER;
    }

    private Object toObject(String name, JsonValue json, JsonObject jsonObject) {
        if (json == null) {
            return null;
        }
        switch (json.getValueType()) {
            case STRING: {
                return jsonObject.getString(name);
            }
            case NUMBER: {
                return jsonObject.getJsonNumber(name).numberValue();
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case NULL: {
                return null;
            }
            case OBJECT: {
                return jsonObject.getJsonObject(name);
            }
            case ARRAY: {
                return jsonObject.getJsonArray(name);
            }
        }
        throw new IllegalStateException(String.format("Unknown JSON value type: %s", json.getValueType()));
    }

    static {
        JSON_WRITERS.put(Integer.class, (builder, name, value) -> builder.add(name, ((Integer)value).intValue()));
        JSON_WRITERS.put(Short.class, (builder, name, value) -> builder.add(name, (int)((Short)value).shortValue()));
        JSON_WRITERS.put(Byte.class, (builder, name, value) -> builder.add(name, (int)((Byte)value).byteValue()));
        JSON_WRITERS.put(AtomicInteger.class, (builder, name, value) -> builder.add(name, ((AtomicInteger)value).get()));
        JSON_WRITERS.put(Float.class, (builder, name, value) -> builder.add(name, (double)((Float)value).floatValue()));
        JSON_WRITERS.put(Double.class, (builder, name, value) -> builder.add(name, ((Double)value).doubleValue()));
        JSON_WRITERS.put(BigInteger.class, (builder, name, value) -> builder.add(name, (BigInteger)value));
        JSON_WRITERS.put(BigDecimal.class, (builder, name, value) -> builder.add(name, (BigDecimal)value));
        JSON_WRITERS.put(Long.class, (builder, name, value) -> builder.add(name, ((Long)value).longValue()));
        JSON_WRITERS.put(String.class, (builder, name, value) -> builder.add(name, (String)value));
        JSON_WRITERS.put(Boolean.class, (builder, name, value) -> builder.add(name, ((Boolean)value).booleanValue()));
        JSON_WRITERS.put(Integer.TYPE, JSON_WRITERS.get(Integer.class));
        JSON_WRITERS.put(Short.TYPE, JSON_WRITERS.get(Short.class));
        JSON_WRITERS.put(Byte.TYPE, JSON_WRITERS.get(Byte.class));
        JSON_WRITERS.put(Float.TYPE, JSON_WRITERS.get(Float.class));
        JSON_WRITERS.put(Double.TYPE, JSON_WRITERS.get(Double.class));
        JSON_WRITERS.put(Long.TYPE, JSON_WRITERS.get(Long.class));
        JSON_WRITERS.put(Boolean.TYPE, JSON_WRITERS.get(Boolean.class));
    }

    @FunctionalInterface
    private static interface DbJsonWriter {
        public void write(JsonObjectBuilder var1, String var2, Object var3);
    }
}

