/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.common.OptionalHelper;
import io.helidon.common.reactive.Flow;
import io.helidon.config.Config;
import io.helidon.config.internal.ConfigKeyImpl;
import io.helidon.config.internal.ListNodeBuilderImpl;
import io.helidon.config.internal.ObjectNodeBuilderImpl;
import io.helidon.config.spi.AbstractSource;
import io.helidon.config.spi.ConfigContext;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import java.io.StringReader;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public abstract class AbstractConfigSource<S>
extends AbstractSource<ConfigNode.ObjectNode, S>
implements ConfigSource {
    private final Function<Config.Key, String> mediaTypeMapping;
    private final Function<Config.Key, ConfigParser> parserMapping;
    private ConfigContext configContext;

    protected AbstractConfigSource(Builder<?, ?> builder) {
        super(builder);
        this.mediaTypeMapping = builder.mediaTypeMapping();
        this.parserMapping = builder.parserMapping();
    }

    @Override
    public final void init(ConfigContext context) {
        this.configContext = context;
    }

    protected ConfigContext configContext() {
        return this.configContext;
    }

    @Override
    protected AbstractSource.Data<ConfigNode.ObjectNode, S> processLoadedData(AbstractSource.Data<ConfigNode.ObjectNode, S> data) {
        if (!data.data().isPresent() || this.mediaTypeMapping == null && this.parserMapping == null) {
            return data;
        }
        return new AbstractSource.Data<ConfigNode.ObjectNode, S>(Optional.of(this.processObject(data.stamp(), ConfigKeyImpl.of(), data.data().get())), data.stamp());
    }

    private ConfigNode processNode(Optional<S> datastamp, ConfigKeyImpl key, ConfigNode node) {
        switch (node.nodeType()) {
            case OBJECT: {
                return this.processObject(datastamp, key, (ConfigNode.ObjectNode)node);
            }
            case LIST: {
                return this.processList(datastamp, key, (ConfigNode.ListNode)node);
            }
            case VALUE: {
                return this.processValue(datastamp, key, (ConfigNode.ValueNode)node);
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
    }

    private ConfigNode.ObjectNode processObject(Optional<S> datastamp, ConfigKeyImpl key, ConfigNode.ObjectNode objectNode) {
        ObjectNodeBuilderImpl builder = (ObjectNodeBuilderImpl)ConfigNode.ObjectNode.builder();
        objectNode.forEach((name, node) -> builder.addNode((String)name, this.processNode(datastamp, key.child((String)name), (ConfigNode)node)));
        return builder.build();
    }

    private ConfigNode.ListNode processList(Optional<S> datastamp, ConfigKeyImpl key, ConfigNode.ListNode listNode) {
        ListNodeBuilderImpl builder = (ListNodeBuilderImpl)ConfigNode.ListNode.builder();
        for (int i = 0; i < listNode.size(); ++i) {
            builder.addNode(this.processNode(datastamp, key.child(Integer.toString(i)), (ConfigNode)listNode.get(i)));
        }
        return builder.build();
    }

    private ConfigNode processValue(Optional<S> datastamp, Config.Key key, ConfigNode.ValueNode valueNode) {
        AtomicReference<ConfigNode.ValueNode> result = new AtomicReference<ConfigNode.ValueNode>(valueNode);
        this.findParserForKey(key).ifPresent(parser -> result.set((ConfigNode.ValueNode)((Object)parser.parse(ConfigParser.Content.create(new StringReader((String)valueNode.get()), null, datastamp)))));
        return result.get();
    }

    private Optional<ConfigParser> findParserForKey(Config.Key key) {
        return OptionalHelper.from(Optional.ofNullable(this.parserMapping).map(mapping -> (ConfigParser)mapping.apply(key))).or(() -> Optional.ofNullable(this.mediaTypeMapping).map(mapping -> (String)mapping.apply(key)).flatMap(mediaType -> this.configContext().findParser((String)mediaType))).asOptional();
    }

    @Override
    public final Flow.Publisher<Optional<ConfigNode.ObjectNode>> changes() {
        return this.changesPublisher();
    }

    public static abstract class Builder<B extends Builder<B, T>, T>
    extends AbstractSource.Builder<B, T, ConfigSource>
    implements io.helidon.common.Builder<ConfigSource> {
        private static final String MEDIA_TYPE_MAPPING_KEY = "media-type-mapping";
        private Function<Config.Key, String> mediaTypeMapping = null;
        private Function<Config.Key, ConfigParser> parserMapping = null;
        private volatile ConfigSource configSource;

        protected Builder(Class<T> targetType) {
            super(targetType);
        }

        public ConfigSource get() {
            if (this.configSource == null) {
                this.configSource = (ConfigSource)this.build();
            }
            return this.configSource;
        }

        @Override
        protected B init(Config metaConfig) {
            metaConfig.get(MEDIA_TYPE_MAPPING_KEY).detach().asMap().ifPresent(this::initMediaTypeMapping);
            return (B)((Builder)super.init(metaConfig));
        }

        private void initMediaTypeMapping(Map<String, String> mediaTypeMapping) {
            this.mediaTypeMapping(key -> (String)mediaTypeMapping.get(key.toString()));
        }

        public B mediaTypeMapping(Function<Config.Key, String> mediaTypeMapping) {
            Objects.requireNonNull(mediaTypeMapping, "mediaTypeMapping cannot be null");
            this.mediaTypeMapping = mediaTypeMapping;
            return (B)((Builder)this.thisBuilder());
        }

        public B parserMapping(Function<Config.Key, ConfigParser> parserMapping) {
            Objects.requireNonNull(parserMapping, "parserMapping cannot be null");
            this.parserMapping = parserMapping;
            return (B)((Builder)this.thisBuilder());
        }

        protected Function<Config.Key, String> mediaTypeMapping() {
            return this.mediaTypeMapping;
        }

        protected Function<Config.Key, ConfigParser> parserMapping() {
            return this.parserMapping;
        }
    }
}

