/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.common.OptionalHelper;
import io.helidon.config.ConfigException;
import io.helidon.config.internal.ObjectNodeBuilderImpl;
import io.helidon.config.spi.ConfigContext;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigSource;
import java.util.Objects;
import java.util.Optional;

public class PrefixedConfigSource
implements ConfigSource {
    private final String key;
    private final ConfigSource source;

    public PrefixedConfigSource(String key, ConfigSource source) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(source, "source cannot be null");
        this.key = key;
        this.source = source;
    }

    @Override
    public String description() {
        return String.format("prefixed[%s]:%s", this.key, this.source.description());
    }

    @Override
    public Optional<ConfigNode.ObjectNode> load() throws ConfigException {
        return OptionalHelper.from(this.source.load().map(originRoot -> new ObjectNodeBuilderImpl().addObject(this.key, (ConfigNode.ObjectNode)originRoot).build())).or(Optional::empty).asOptional();
    }

    @Override
    public void init(ConfigContext context) {
        this.source.init(context);
    }
}

