/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class ConfigKeyImpl
implements Config.Key {
    private final String name;
    private final ConfigKeyImpl parent;
    private final List<String> path;
    private final String fullKey;

    private ConfigKeyImpl(ConfigKeyImpl parent, String name) {
        Objects.requireNonNull(name, "name is mandatory");
        if (parent != null && name.equals("")) {
            if (parent.isRoot()) {
                parent = null;
            } else {
                throw new IllegalArgumentException("Illegal empty name. Only root can be empty.");
            }
        }
        if (name.contains(".")) {
            throw new IllegalArgumentException("Illegal key token format. Dot character ('.') is not ");
        }
        this.parent = parent;
        ArrayList<String> path = new ArrayList<String>();
        StringBuilder fullSB = new StringBuilder();
        if (parent != null) {
            path.addAll(parent.path);
            fullSB.append(parent.fullKey);
        }
        if (!name.equals("")) {
            if (fullSB.length() > 0) {
                fullSB.append(".");
            }
            path.add(name);
            fullSB.append(name);
        }
        this.name = Config.Key.unescapeName(name);
        this.path = Collections.unmodifiableList(path);
        this.fullKey = fullSB.toString();
    }

    @Override
    public ConfigKeyImpl parent() {
        return this.parent;
    }

    public static ConfigKeyImpl of() {
        return new ConfigKeyImpl(null, "");
    }

    public static ConfigKeyImpl of(String key) {
        return ConfigKeyImpl.of().child(key);
    }

    public ConfigKeyImpl child(String key) {
        return this.child(Arrays.asList(key.split("\\.")));
    }

    @Override
    public ConfigKeyImpl child(Config.Key key) {
        List<String> path;
        if (key instanceof ConfigKeyImpl) {
            path = ((ConfigKeyImpl)key).path;
        } else {
            path = new LinkedList<String>();
            while (!key.isRoot()) {
                path.add(0, key.name());
                key = key.parent();
            }
        }
        return this.child(path);
    }

    private ConfigKeyImpl child(List<String> path) {
        ConfigKeyImpl result = this;
        for (String name : path) {
            result = new ConfigKeyImpl(result, name);
        }
        return result;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.fullKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigKeyImpl key = (ConfigKeyImpl)o;
        return Objects.equals(this.name, key.name) && Objects.equals(this.parent, key.parent);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parent);
    }

    @Override
    public int compareTo(Config.Key that) {
        return this.toString().compareTo(that.toString());
    }
}

