/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.reactive.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

abstract class SuspendablePublisher<T>
implements Flow.Publisher<T> {
    private final Flow.Publisher<T> delegatePublisher;
    private final AtomicBoolean running;
    private final AtomicInteger numberOfSubscribers;
    private final Object lock = new Object();

    SuspendablePublisher(Flow.Publisher<T> delegatePublisher) {
        this.delegatePublisher = delegatePublisher;
        this.running = new AtomicBoolean(false);
        this.numberOfSubscribers = new AtomicInteger(0);
    }

    protected abstract void onFirstSubscriptionRequest();

    protected abstract void onLastSubscriptionCancel();

    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.delegatePublisher.subscribe(new SuspendableSubscriber(subscriber, this::beforeRequestHook, this::afterCancelHook));
        this.numberOfSubscribers.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeRequestHook() {
        if (!this.running.get()) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.running.get()) {
                    this.running.set(true);
                    this.onFirstSubscriptionRequest();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterCancelHook() {
        this.numberOfSubscribers.decrementAndGet();
        if (this.numberOfSubscribers.intValue() == 0 && this.running.get()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.running.get()) {
                    this.onLastSubscriptionCancel();
                    this.running.set(false);
                }
            }
        }
    }

    private static class SuspendableSubscription
    implements Flow.Subscription {
        private final Flow.Subscription subscription;
        private final Runnable beforeRequestHook;
        private final Runnable afterCancelHook;

        private SuspendableSubscription(Flow.Subscription subscription, Runnable beforeRequestHook, Runnable afterCancelHook) {
            this.subscription = subscription;
            this.beforeRequestHook = beforeRequestHook;
            this.afterCancelHook = afterCancelHook;
        }

        public void request(long n) {
            this.beforeRequestHook.run();
            this.subscription.request(n);
        }

        public void cancel() {
            this.subscription.cancel();
            this.afterCancelHook.run();
        }
    }

    private static class SuspendableSubscriber<T>
    implements Flow.Subscriber<T> {
        private final Flow.Subscriber<? super T> delegate;
        private final Runnable beforeRequestHook;
        private final Runnable afterCancelHook;

        private SuspendableSubscriber(Flow.Subscriber<? super T> delegate, Runnable beforeRequestHook, Runnable afterCancelHook) {
            this.delegate = delegate;
            this.beforeRequestHook = beforeRequestHook;
            this.afterCancelHook = afterCancelHook;
        }

        public void onSubscribe(Flow.Subscription subscription) {
            this.delegate.onSubscribe((Flow.Subscription)new SuspendableSubscription(subscription, this.beforeRequestHook, this.afterCancelHook));
        }

        public void onNext(T item) {
            this.delegate.onNext(item);
        }

        public void onError(Throwable throwable) {
            this.delegate.onError(throwable);
        }

        public void onComplete() {
            this.delegate.onComplete();
        }
    }
}

