/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.InMemoryOverrideSource;
import io.helidon.config.internal.ClasspathOverrideSource;
import io.helidon.config.internal.FileOverrideSource;
import io.helidon.config.internal.UrlOverrideSource;
import io.helidon.config.spi.AbstractOverrideSource;
import io.helidon.config.spi.OverrideSource;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;

public final class OverrideSources {
    private OverrideSources() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static OverrideSource empty() {
        return OverridingSourceHolder.EMPTY;
    }

    public static OverrideSource create(Map<String, String> overrideValues) {
        return InMemoryOverrideSource.builder(overrideValues).build();
    }

    public static AbstractOverrideSource.Builder<? extends AbstractOverrideSource.Builder<?, Path>, Path> classpath(String resourceName) {
        return new ClasspathOverrideSource.ClasspathBuilder(resourceName);
    }

    public static AbstractOverrideSource.Builder<? extends AbstractOverrideSource.Builder<?, Path>, Path> file(String file) {
        return new FileOverrideSource.FileBuilder(Paths.get(file, new String[0]));
    }

    public static AbstractOverrideSource.Builder<? extends AbstractOverrideSource.Builder<?, URL>, URL> url(URL url) {
        return new UrlOverrideSource.UrlBuilder(url);
    }

    private static final class OverridingSourceHolder {
        private static final OverrideSource EMPTY = Optional::empty;

        private OverridingSourceHolder() {
            throw new AssertionError((Object)"Instantiation not allowed.");
        }
    }
}

