/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ConfigException;
import io.helidon.config.spi.AbstractOverrideSource;
import io.helidon.config.spi.AbstractSource;
import io.helidon.config.spi.OverrideSource;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class InMemoryOverrideSource
extends AbstractOverrideSource<Object> {
    private final OverrideSource.OverrideData overrideData;

    private InMemoryOverrideSource(Builder builder) {
        super(builder);
        this.overrideData = builder.overrideData;
    }

    static Builder builder(Map<String, String> overrideValues) {
        return new Builder(overrideValues.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
    }

    static Builder builder(List<Map.Entry<String, String>> overrideValues) {
        return new Builder(overrideValues);
    }

    @Override
    protected Optional<Object> dataStamp() {
        return Optional.of(this);
    }

    @Override
    protected AbstractSource.Data<OverrideSource.OverrideData, Object> loadData() throws ConfigException {
        return new AbstractSource.Data<OverrideSource.OverrideData, Object>(Optional.of(this.overrideData), Optional.of(this));
    }

    static final class Builder
    extends AbstractOverrideSource.Builder<Builder, Void> {
        private OverrideSource.OverrideData overrideData;
        private List<Map.Entry<String, String>> overrideWildcards;

        Builder(List<Map.Entry<String, String>> overrideWildcards) {
            super(Void.class);
            Objects.requireNonNull(overrideWildcards, "overrideValues cannot be null");
            this.overrideWildcards = overrideWildcards;
        }

        @Override
        public InMemoryOverrideSource build() {
            if (this.overrideWildcards.isEmpty()) {
                throw new ConfigException("Override values cannot be empty.");
            }
            this.overrideData = OverrideSource.OverrideData.createFromWildcards(this.overrideWildcards);
            return new InMemoryOverrideSource(this);
        }
    }
}

