/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.reactive.Flow;
import io.helidon.config.SuspendablePublisher;
import io.helidon.config.internal.ConfigFileTypeDetector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.nio.file.Path;
import java.nio.file.spi.FileTypeDetector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConfigHelper {
    private static final int DEFAULT_BUFFER_CAPACITY = 1024;
    private static final Logger LOGGER = Logger.getLogger(ConfigFileTypeDetector.class.getName());

    private ConfigHelper() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static Reader createReader(Readable readable) throws IOException {
        return ConfigHelper.createReader(readable, 1024);
    }

    static Reader createReader(Readable readable, int bufferCapacity) throws IOException {
        if (readable instanceof Reader) {
            return (Reader)readable;
        }
        CharBuffer cb = CharBuffer.allocate(bufferCapacity);
        StringBuilder sb = new StringBuilder();
        while (readable.read(cb) != -1) {
            cb.flip();
            sb.append(cb.toString());
        }
        return new StringReader(sb.toString());
    }

    public static <T> Flow.Subscriber<T> subscriber(Function<T, Boolean> onNextFunction) {
        return new OnNextFunctionSubscriber(onNextFunction);
    }

    public static <T> Flow.Publisher<T> suspendablePublisher(Flow.Publisher<T> delegatePublisher, final Runnable onFirstSubscriptionRequest, final Runnable onLastSubscriptionCancel) {
        return new SuspendablePublisher<T>(delegatePublisher){

            @Override
            protected void onFirstSubscriptionRequest() {
                onFirstSubscriptionRequest.run();
            }

            @Override
            protected void onLastSubscriptionCancel() {
                onLastSubscriptionCancel.run();
            }
        };
    }

    public static String detectContentType(Path path) {
        String result = null;
        try {
            FileTypeDetector detector;
            Iterator<FileTypeDetector> iterator = FileTypeDetectors.INSTALLED_DETECTORS.iterator();
            while (iterator.hasNext() && (result = (detector = iterator.next()).probeContentType(path)) == null) {
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, e, () -> "Failed to find content type for " + path);
        }
        return result;
    }

    private static class OnNextFunctionSubscriber<T>
    implements Flow.Subscriber<T> {
        private final Function<T, Boolean> onNextFunction;
        private final Logger logger;
        private Flow.Subscription subscription;

        private OnNextFunctionSubscriber(Function<T, Boolean> onNextFunction) {
            this.onNextFunction = onNextFunction;
            this.logger = Logger.getLogger(OnNextFunctionSubscriber.class.getName() + "." + Integer.toHexString(System.identityHashCode(onNextFunction)));
        }

        public void onSubscribe(Flow.Subscription subscription) {
            this.logger.finest(() -> "onSubscribe: " + subscription);
            this.subscription = subscription;
            subscription.request(Long.MAX_VALUE);
        }

        public void onNext(T item) {
            boolean cancel = this.onNextFunction.apply(item) == false;
            this.logger.finest(() -> "onNext: " + item + " => " + (cancel ? "CANCEL" : "FOLLOW"));
            if (cancel) {
                this.subscription.cancel();
            }
        }

        public void onError(Throwable throwable) {
            this.logger.log(Level.WARNING, throwable, () -> "Config Changes support failed. " + throwable.getLocalizedMessage());
        }

        public void onComplete() {
            this.logger.config("Config Changes support finished. There will no other Config reload.");
        }
    }

    private static class FileTypeDetectors {
        static final List<FileTypeDetector> INSTALLED_DETECTORS = FileTypeDetectors.loadInstalledDetectors();

        private FileTypeDetectors() {
        }

        private static List<FileTypeDetector> loadInstalledDetectors() {
            return AccessController.doPrivileged(new PrivilegedAction<List<FileTypeDetector>>(){

                @Override
                public List<FileTypeDetector> run() {
                    LinkedList<FileTypeDetector> list = new LinkedList<FileTypeDetector>();
                    ServiceLoader<FileTypeDetector> loader = ServiceLoader.load(FileTypeDetector.class);
                    for (FileTypeDetector detector : loader) {
                        list.add(detector);
                    }
                    return list;
                }
            });
        }
    }
}

