/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.internal.ValueResolvingFilter;
import io.helidon.config.spi.ConfigFilter;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ConfigFilters {
    private ConfigFilters() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static ValueResolvingBuilder valueResolving() {
        return new ValueResolvingBuilder();
    }

    public static final class ValueResolvingBuilder
    implements Supplier<Function<Config, ConfigFilter>> {
        public static final String FAIL_ON_MISSING_REFERENCE_KEY_NAME = "config.value-resolving-filter.fail-on-missing-reference";
        private boolean failOnMissingReference = false;

        private ValueResolvingBuilder() {
        }

        public static ValueResolvingBuilder create(Config metaConfig) throws ConfigMappingException, MissingValueException {
            ValueResolvingBuilder builder = new ValueResolvingBuilder();
            builder.failOnMissingReference(metaConfig.get(FAIL_ON_MISSING_REFERENCE_KEY_NAME).asBoolean().orElse(false));
            return builder;
        }

        public ValueResolvingBuilder failOnMissingReference(boolean failOnMissing) {
            this.failOnMissingReference = failOnMissing;
            return this;
        }

        public Function<Config, ConfigFilter> build() {
            return c -> new ValueResolvingFilter(this.failOnMissingReference);
        }

        @Override
        public Function<Config, ConfigFilter> get() {
            return this.build();
        }
    }
}

