/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.objectmapping;

import io.helidon.config.Config;
import io.helidon.config.objectmapping.ObjectConfigMappers;
import io.helidon.config.objectmapping.ReflectionUtil;
import io.helidon.config.spi.ConfigMapperProvider;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Priority;

@Priority(value=1000)
public class ObjectConfigMapperProvider
implements ConfigMapperProvider {
    private static final String METHOD_FROM = "from";
    private static final String METHOD_OF = "of";
    private static final String METHOD_VALUE_OF = "valueOf";
    private static final String METHOD_FROM_CONFIG = "fromConfig";
    private static final String METHOD_FROM_STRING = "fromString";
    private static final String METHOD_PARSE = "parse";
    private static final String METHOD_CREATE = "create";

    public Map<Class<?>, Function<Config, ?>> mappers() {
        return Map.of();
    }

    public <T> Optional<Function<Config, T>> mapper(Class<T> type) {
        return ObjectConfigMapperProvider.findStaticConfigMethodMapper(type, METHOD_CREATE).or(() -> ObjectConfigMapperProvider.findStaticConfigMethodMapper(type, METHOD_FROM)).or(() -> ObjectConfigMapperProvider.findConfigConstructorMapper(type)).or(() -> ObjectConfigMapperProvider.findStaticConfigMethodMapper(type, METHOD_OF)).or(() -> ObjectConfigMapperProvider.findStaticConfigMethodMapper(type, METHOD_VALUE_OF)).or(() -> ObjectConfigMapperProvider.findStaticConfigMethodMapper(type, METHOD_FROM_CONFIG)).or(() -> ObjectConfigMapperProvider.findStaticStringMethodMapper(type, METHOD_FROM)).or(() -> ObjectConfigMapperProvider.findStaticStringMethodMapper(type, METHOD_PARSE)).or(() -> ObjectConfigMapperProvider.findParseCharSequenceMethodMapper(type)).or(() -> ObjectConfigMapperProvider.findStringConstructorMapper(type)).or(() -> ObjectConfigMapperProvider.findStaticStringMethodMapper(type, METHOD_OF)).or(() -> ObjectConfigMapperProvider.findStaticStringMethodMapper(type, METHOD_VALUE_OF)).or(() -> ObjectConfigMapperProvider.findStaticStringMethodMapper(type, METHOD_FROM_STRING)).or(() -> ObjectConfigMapperProvider.findBuilderMethodMapper(type)).or(() -> ObjectConfigMapperProvider.findBuilderClassMapper(type)).or(() -> ObjectConfigMapperProvider.findStaticMethodWithParamsMapper(type, METHOD_FROM)).or(() -> ObjectConfigMapperProvider.findStaticMethodWithParamsMapper(type, METHOD_CREATE)).or(() -> ObjectConfigMapperProvider.findConstructorWithParamsMapper(type)).or(() -> ObjectConfigMapperProvider.findGenericMapper(type));
    }

    private static <T> Optional<Function<Config, T>> findStaticConfigMethodMapper(Class<T> type, String methodName) {
        return ReflectionUtil.findStaticMethod(type, methodName, Config.class).map(handle -> new ObjectConfigMappers.ConfigMethodHandleConfigMapper(type, methodName + "(Config) method", (MethodHandle)handle));
    }

    private static <T> Optional<Function<Config, T>> findStaticStringMethodMapper(Class<T> type, String methodName) {
        Optional<MethodHandle> method = ReflectionUtil.findStaticMethod(type, methodName, String.class);
        if (method.isEmpty()) {
            method = ReflectionUtil.findStaticMethod(type, methodName, CharSequence.class);
        }
        return method.map(handle -> new ObjectConfigMappers.StringMethodHandleConfigMapper(type, methodName + "(String) method", (MethodHandle)handle));
    }

    private static <T> Optional<Function<Config, T>> findParseCharSequenceMethodMapper(Class<T> type) {
        return ReflectionUtil.findStaticMethod(type, METHOD_PARSE, CharSequence.class).map(handle -> new ObjectConfigMappers.StringMethodHandleConfigMapper(type, "parse(CharSequence) method", (MethodHandle)handle));
    }

    private static <T> Optional<Function<Config, T>> findConfigConstructorMapper(Class<T> type) {
        return ReflectionUtil.findConstructor(type, Config.class).map(handle -> new ObjectConfigMappers.ConfigMethodHandleConfigMapper(type, "Config constructor", (MethodHandle)handle));
    }

    private static <T> Optional<Function<Config, T>> findStringConstructorMapper(Class<T> type) {
        return ReflectionUtil.findConstructor(type, String.class).map(handle -> new ObjectConfigMappers.StringMethodHandleConfigMapper(type, "String constructor", (MethodHandle)handle));
    }

    private static <T> Optional<Function<Config, T>> findBuilderMethodMapper(Class<T> type) {
        return ReflectionUtil.findBuilderMethod(type).map(ObjectConfigMappers.BuilderConfigMapper::new);
    }

    private static <T> Optional<Function<Config, T>> findBuilderClassMapper(Class<T> type) {
        return ReflectionUtil.findBuilderConstructor(type).map(ObjectConfigMappers.BuilderConfigMapper::new);
    }

    private static <T> Optional<Function<Config, T>> findStaticMethodWithParamsMapper(Class<T> type, String methodName) {
        return ReflectionUtil.findStaticMethodWithParameters(type, methodName).map(ObjectConfigMappers.FactoryMethodConfigMapper::new);
    }

    private static <T> Optional<Function<Config, T>> findConstructorWithParamsMapper(Class<T> type) {
        return ReflectionUtil.findConstructorWithParameters(type).map(ObjectConfigMappers.FactoryMethodConfigMapper::new);
    }

    private static <T> Optional<Function<Config, T>> findGenericMapper(Class<T> type) {
        try {
            return ReflectionUtil.findConstructor(type, new Class[0]).map(methodHandle -> new ObjectConfigMappers.GenericConfigMapper(type, (MethodHandle)methodHandle));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }
}

