/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.serviceloader;

import io.helidon.common.Prioritized;
import jakarta.annotation.Priority;
import java.util.Comparator;
import java.util.List;

public final class Priorities {
    private Priorities() {
    }

    public static int find(Class<?> aClass, int defaultPriority) {
        Priority priorityAnnot = aClass.getAnnotation(Priority.class);
        if (null != priorityAnnot) {
            return priorityAnnot.value();
        }
        return defaultPriority;
    }

    public static int find(Object anObject, int defaultPriority) {
        if (anObject instanceof Class) {
            return Priorities.find((Class)anObject, defaultPriority);
        }
        if (anObject instanceof Prioritized) {
            return ((Prioritized)anObject).priority();
        }
        Priority prio = anObject.getClass().getAnnotation(Priority.class);
        if (null == prio) {
            return defaultPriority;
        }
        return prio.value();
    }

    public static void sort(List<? extends Prioritized> list) {
        list.sort(Comparator.comparingInt(Prioritized::priority));
    }

    public static void sort(List<?> list, int defaultPriority) {
        list.sort(Priorities.priorityComparator(defaultPriority));
    }

    public static <S> Comparator<S> priorityComparator(int defaultPriority) {
        return Comparator.comparingInt(it -> {
            if (it instanceof Class) {
                return Priorities.find((Class)it, defaultPriority);
            }
            return Priorities.find(it, defaultPriority);
        });
    }
}

