/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;

final class SingleObserveOn<T>
extends CompletionSingle<T> {
    private final Single<T> source;
    private final Executor executor;

    SingleObserveOn(Single<T> source, Executor executor) {
        this.source = source;
        this.executor = executor;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new ObserveOnSubscriber<T>(subscriber, this.executor));
    }

    static final class ObserveOnSubscriber<T>
    implements Flow.Subscriber<T>,
    Flow.Subscription,
    Runnable {
        private final Flow.Subscriber<? super T> downstream;
        private final Executor executor;
        private Flow.Subscription upstream;
        private T item;
        private Throwable error;
        private volatile boolean canceled;
        private volatile boolean upstreamReady;
        private volatile boolean requestReady;

        ObserveOnSubscriber(Flow.Subscriber<? super T> downstream, Executor executor) {
            this.downstream = downstream;
            this.executor = executor;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
            this.upstreamReady = true;
            if (this.requestReady) {
                subscription.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T item) {
            this.item = item;
            this.executor.execute(this);
        }

        @Override
        public void onError(Throwable throwable) {
            this.error = throwable;
            this.executor.execute(this);
        }

        @Override
        public void onComplete() {
            if (this.item == null && this.error == null) {
                this.executor.execute(this);
            }
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden"));
            } else {
                this.requestReady = true;
                if (this.upstreamReady) {
                    this.upstream.request(Long.MAX_VALUE);
                }
            }
        }

        @Override
        public void cancel() {
            this.canceled = true;
            this.upstream.cancel();
        }

        @Override
        public void run() {
            if (!this.canceled) {
                Throwable ex = this.error;
                if (ex != null) {
                    this.downstream.onError(ex);
                } else {
                    T item = this.item;
                    if (item != null) {
                        this.downstream.onNext(item);
                    }
                    this.downstream.onComplete();
                }
            }
        }
    }
}

