/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.SubscriptionHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

final class SingleFlatMapMulti<T, R>
implements Multi<R> {
    private final Single<T> source;
    private final Function<? super T, ? extends Flow.Publisher<? extends R>> mapper;

    SingleFlatMapMulti(Single<T> source, Function<? super T, ? extends Flow.Publisher<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super R> subscriber) {
        this.source.subscribe(new FlatMapSubscriber<T, R>(subscriber, this.mapper));
    }

    static final class FlatMapSubscriber<T, R>
    extends AtomicLong
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super R> downstream;
        private final Function<? super T, ? extends Flow.Publisher<? extends R>> mapper;
        private final InnerSubscriber<R> inner;
        private Flow.Subscription upstream;

        FlatMapSubscriber(Flow.Subscriber<? super R> downstream, Function<? super T, ? extends Flow.Publisher<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.inner = new InnerSubscriber<R>(downstream, this);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T item) {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                Flow.Publisher<R> p;
                try {
                    p = Objects.requireNonNull(this.mapper.apply(item), "The mapper returned a null Publisher");
                }
                catch (Throwable ex) {
                    this.onError(ex);
                    return;
                }
                this.upstream = SubscriptionHelper.CANCELED;
                p.subscribe(this.inner);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.inner, this, n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELED;
            SubscriptionHelper.cancel(this.inner);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
        }

        static final class InnerSubscriber<R>
        extends AtomicReference<Flow.Subscription>
        implements Flow.Subscriber<R> {
            private final Flow.Subscriber<? super R> downstream;
            private final AtomicLong requested;

            InnerSubscriber(Flow.Subscriber<? super R> downstream, AtomicLong requested) {
                this.downstream = downstream;
                this.requested = requested;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                SubscriptionHelper.deferredSetOnce(this, this.requested, subscription);
            }

            @Override
            public void onNext(R item) {
                this.downstream.onNext(item);
            }

            @Override
            public void onError(Throwable throwable) {
                this.downstream.onError(throwable);
            }

            @Override
            public void onComplete() {
                this.downstream.onComplete();
            }

            private void writeObject(ObjectOutputStream stream) throws IOException {
                stream.defaultWriteObject();
            }

            private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
                stream.defaultReadObject();
            }
        }
    }
}

