/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.DeferredScalarSubscription;
import io.helidon.common.reactive.EmptySubscription;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

final class MultiCollectPublisher<T, U>
extends CompletionSingle<U> {
    private final Multi<T> source;
    private final Supplier<? extends U> collectionSupplier;
    private final BiConsumer<U, T> accumulator;

    MultiCollectPublisher(Multi<T> source, Supplier<? extends U> collectionSupplier, BiConsumer<U, T> combiner) {
        this.source = source;
        this.collectionSupplier = collectionSupplier;
        this.accumulator = combiner;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super U> subscriber) {
        U collection;
        try {
            collection = Objects.requireNonNull(this.collectionSupplier.get(), "The collectionSupplier returned a null value");
        }
        catch (Throwable ex) {
            subscriber.onSubscribe(EmptySubscription.INSTANCE);
            subscriber.onError(ex);
            return;
        }
        this.source.subscribe(new CollectSubscriber<T, U>(subscriber, collection, this.accumulator));
    }

    static final class CollectSubscriber<T, U>
    extends DeferredScalarSubscription<U>
    implements Flow.Subscriber<T> {
        private U collection;
        private final BiConsumer<U, T> accumulator;
        private Flow.Subscription upstream;

        CollectSubscriber(Flow.Subscriber<? super U> downstream, U collection, BiConsumer<U, T> accumulator) {
            super(downstream);
            this.collection = collection;
            this.accumulator = accumulator;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream().onSubscribe(this);
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T item) {
            Flow.Subscription s = this.upstream;
            U c = this.collection;
            if (s != SubscriptionHelper.CANCELED && c != null) {
                try {
                    this.accumulator.accept(c, item);
                }
                catch (Throwable ex) {
                    super.cancel();
                    s.cancel();
                    this.onError(ex);
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                this.collection = null;
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream().onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                U c = this.collection;
                this.collection = null;
                this.upstream = SubscriptionHelper.CANCELED;
                if (c != null) {
                    this.complete(c);
                }
            }
        }

        @Override
        public void cancel() {
            this.collection = null;
            super.cancel();
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELED;
        }
    }
}

