/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.DeferredScalarSubscription;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

final class SingleOnCompleteResumeWith<T>
extends CompletionSingle<T> {
    private final Single<T> source;
    private final Function<Optional<T>, ? extends Single<? extends T>> fallbackFunction;

    SingleOnCompleteResumeWith(Single<T> source, Function<Optional<T>, ? extends Single<? extends T>> fallbackFunction) {
        this.source = source;
        this.fallbackFunction = fallbackFunction;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        this.source.subscribe(new OnCompleteResumeWithSubscriber<T>(subscriber, this.fallbackFunction));
    }

    static final class OnCompleteResumeWithSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Flow.Subscriber<T> {
        private final Function<Optional<T>, ? extends Single<? extends T>> fallbackFunction;
        private final FallbackSubscriber<T> fallbackSubscriber;
        private Flow.Subscription upstream;
        private T item;

        OnCompleteResumeWithSubscriber(Flow.Subscriber<? super T> downstream, Function<Optional<T>, ? extends Single<? extends T>> fallbackSupplier) {
            super(downstream);
            this.fallbackFunction = fallbackSupplier;
            this.fallbackSubscriber = new FallbackSubscriber(this);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.subscribeSelf();
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T item) {
            this.item = item;
            this.upstream = SubscriptionHelper.CANCELED;
            this.complete(item);
        }

        @Override
        public void onError(Throwable throwable) {
            this.upstream = SubscriptionHelper.CANCELED;
            this.error(throwable);
        }

        @Override
        public void onComplete() {
            Single<T> fallback;
            try {
                fallback = Objects.requireNonNull(this.fallbackFunction.apply(Optional.ofNullable(this.item)), "The fallback function returned a null Single");
            }
            catch (Throwable ex) {
                this.error(ex);
                return;
            }
            fallback.subscribe(this.fallbackSubscriber);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
            SubscriptionHelper.cancel(this.fallbackSubscriber);
        }

        static final class FallbackSubscriber<T>
        extends AtomicReference<Flow.Subscription>
        implements Flow.Subscriber<T> {
            private final OnCompleteResumeWithSubscriber<T> parent;

            FallbackSubscriber(OnCompleteResumeWithSubscriber<T> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                SubscriptionHelper.setOnce(this, subscription);
                subscription.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(T item) {
                this.parent.complete(item);
            }

            @Override
            public void onError(Throwable throwable) {
                this.parent.error(throwable);
            }

            @Override
            public void onComplete() {
                this.parent.complete();
            }
        }
    }
}

