/*
 * Copyright (c) 2020, 2021 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.helidon.common.reactive;

import java.util.concurrent.Flow;

/**
 * Implementation of {@link Single} that represents the absence of a value by
 * invoking {@link java.util.concurrent.Flow.Subscriber#onComplete() } during
 * {@link java.util.concurrent.Flow.Publisher#subscribe(java.util.concurrent.Flow.Subscriber)}.
 */
final class SingleEmpty extends CompletionSingle<Object> {

    /**
     * Singleton instance.
     */
    private static final SingleEmpty INSTANCE = new SingleEmpty();

    private SingleEmpty() {
    }

    @Override
    public void subscribe(Flow.Subscriber<? super Object> subscriber) {
        subscriber.onSubscribe(EmptySubscription.INSTANCE);
        subscriber.onComplete();
    }

    @SuppressWarnings("unchecked")
    static <T> Single<T> instance() {
        return (Single<T>) INSTANCE;
    }
}
