/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Flow;
import java.util.function.Function;

final class MultiDistinctPublisher<T, K>
implements Multi<T> {
    private final Multi<T> source;
    private final Function<T, K> keySelector;

    MultiDistinctPublisher(Multi<T> source, Function<T, K> keySelector) {
        this.source = source;
        this.keySelector = keySelector;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new DistinctSubscriber<T, K>(subscriber, this.keySelector));
    }

    static final class DistinctSubscriber<T, K>
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private final Function<T, K> keySelector;
        private Set<K> memory;
        private Flow.Subscription upstream;

        DistinctSubscriber(Flow.Subscriber<? super T> downstream, Function<T, K> keySelector) {
            this.downstream = downstream;
            this.keySelector = keySelector;
            this.memory = new HashSet<K>();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(T item) {
            Flow.Subscription s = this.upstream;
            Set<K> m = this.memory;
            if (s != SubscriptionHelper.CANCELED && m != null) {
                boolean pass;
                try {
                    pass = this.memory.add(this.keySelector.apply(item));
                }
                catch (Throwable ex) {
                    s.cancel();
                    this.onError(ex);
                    return;
                }
                if (pass) {
                    this.downstream.onNext(item);
                } else {
                    s.request(1L);
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.memory = null;
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.memory = null;
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.memory = null;
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELED;
        }
    }
}

