/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SingleSubscription;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class MultiDefaultIfEmpty<T>
implements Multi<T> {
    private final Multi<T> source;
    private final T defaultItem;

    MultiDefaultIfEmpty(Multi<T> source, T defaultItem) {
        this.source = source;
        this.defaultItem = defaultItem;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new DefaultIfEmptySubscriber<T>(subscriber, this.defaultItem));
    }

    static final class DefaultIfEmptySubscriber<T>
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private final T defaultItem;
        private final AtomicLong requested;
        private final AtomicReference<Flow.Subscription> fallback;
        private Flow.Subscription upstream;
        private boolean nonEmpty;

        DefaultIfEmptySubscriber(Flow.Subscriber<? super T> downstream, T defaultItem) {
            this.downstream = downstream;
            this.defaultItem = defaultItem;
            this.requested = new AtomicLong();
            this.fallback = new AtomicReference();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(T item) {
            this.nonEmpty = true;
            this.downstream.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            this.downstream.onError(throwable);
        }

        @Override
        public void onComplete() {
            if (this.nonEmpty) {
                this.downstream.onComplete();
            } else {
                SubscriptionHelper.deferredSetOnce(this.fallback, this.requested, new SingleSubscription<T>(this.defaultItem, this.downstream));
            }
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
            SubscriptionHelper.deferredRequest(this.fallback, this.requested, n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            SubscriptionHelper.cancel(this.fallback);
        }
    }
}

