/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import io.helidon.common.reactive.TerminatedFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class MultiTimeout<T>
implements Multi<T> {
    private final Multi<T> source;
    private final long timeout;
    private final TimeUnit unit;
    private final ScheduledExecutorService executor;
    private final Flow.Publisher<T> fallback;

    MultiTimeout(Multi<T> source, long timeout, TimeUnit unit, ScheduledExecutorService executor, Flow.Publisher<T> fallback) {
        this.source = source;
        this.timeout = timeout;
        this.unit = unit;
        this.executor = executor;
        this.fallback = fallback;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        TimeoutSubscriber<T> parent = new TimeoutSubscriber<T>(subscriber, this.timeout, this.unit, this.executor, this.fallback);
        subscriber.onSubscribe(parent);
        parent.schedule(0L);
        this.source.subscribe(parent);
    }

    static final class TimeoutSubscriber<T>
    extends AtomicLong
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private final long timeout;
        private final TimeUnit unit;
        private final ScheduledExecutorService executor;
        private final Flow.Publisher<T> fallback;
        private final AtomicLong requested;
        private final AtomicReference<Future<?>> future;
        private final FallbackSubscriber<T> fallbackSubscriber;
        private long emitted;
        private final AtomicReference<Flow.Subscription> upstream;
        private final AtomicLong requestedInitial;

        TimeoutSubscriber(Flow.Subscriber<? super T> downstream, long timeout, TimeUnit unit, ScheduledExecutorService executor, Flow.Publisher<T> fallback) {
            this.downstream = downstream;
            this.timeout = timeout;
            this.unit = unit;
            this.executor = executor;
            this.fallback = fallback;
            this.requested = new AtomicLong();
            this.future = new AtomicReference();
            this.fallbackSubscriber = new FallbackSubscriber<T>(downstream, this.requested);
            this.upstream = new AtomicReference();
            this.requestedInitial = new AtomicLong();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this.requestedInitial, subscription);
        }

        void schedule(long index) {
            TerminatedFuture.setFuture(this.future, this.executor.schedule(new TimeoutTask(this, index), this.timeout, this.unit));
        }

        @Override
        public void onNext(T item) {
            long index = this.get();
            if (index != Long.MAX_VALUE && this.compareAndSet(index, index + 1L)) {
                Future task = this.future.getAndSet(null);
                if (task != null) {
                    task.cancel(true);
                }
                ++this.emitted;
                this.downstream.onNext(item);
                this.schedule(index + 1L);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                TerminatedFuture.cancel(this.future);
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                TerminatedFuture.cancel(this.future);
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden"));
                return;
            }
            SubscriptionHelper.deferredRequest(this.upstream, this.requestedInitial, n);
            SubscriptionHelper.deferredRequest(this.fallbackSubscriber, this.requested, n);
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
            TerminatedFuture.cancel(this.future);
            SubscriptionHelper.cancel(this.fallbackSubscriber);
        }

        void timeout(long index) {
            if (this.compareAndSet(index, Long.MAX_VALUE)) {
                this.future.lazySet(TerminatedFuture.FINISHED);
                SubscriptionHelper.cancel(this.upstream);
                if (this.fallback == null) {
                    this.downstream.onError(new TimeoutException());
                } else {
                    long p = this.emitted;
                    if (p != 0L) {
                        SubscriptionHelper.produced(this.requested, p);
                    }
                    this.fallback.subscribe(this.fallbackSubscriber);
                }
            }
        }

        static final class FallbackSubscriber<T>
        extends AtomicReference<Flow.Subscription>
        implements Flow.Subscriber<T> {
            private final Flow.Subscriber<? super T> downstream;
            private final AtomicLong requested;

            FallbackSubscriber(Flow.Subscriber<? super T> downstream, AtomicLong requested) {
                this.downstream = downstream;
                this.requested = requested;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                SubscriptionHelper.deferredSetOnce(this, this.requested, subscription);
            }

            @Override
            public void onNext(T item) {
                this.downstream.onNext(item);
            }

            @Override
            public void onError(Throwable throwable) {
                this.downstream.onError(throwable);
            }

            @Override
            public void onComplete() {
                this.downstream.onComplete();
            }
        }

        static final class TimeoutTask
        implements Callable<Void> {
            private final TimeoutSubscriber<?> parent;
            private final long index;

            TimeoutTask(TimeoutSubscriber<?> parent, long index) {
                this.parent = parent;
                this.index = index;
            }

            @Override
            public Void call() throws Exception {
                this.parent.timeout(this.index);
                return null;
            }
        }
    }
}

