/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.concurrent.Flow;
import java.util.function.Consumer;

final class FunctionalSubscriber<T>
implements Flow.Subscriber<T> {
    private final Consumer<? super T> consumer;
    private final Consumer<? super Throwable> errorConsumer;
    private final Runnable completeConsumer;
    private final Consumer<? super Flow.Subscription> subscriptionConsumer;
    private Flow.Subscription subscription;

    FunctionalSubscriber(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer, Runnable completeConsumer, Consumer<? super Flow.Subscription> subscriptionConsumer) {
        this.consumer = consumer;
        this.errorConsumer = errorConsumer;
        this.completeConsumer = completeConsumer;
        this.subscriptionConsumer = subscriptionConsumer;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        if (this.subscription == null) {
            this.subscription = subscription;
            if (this.subscriptionConsumer != null) {
                try {
                    this.subscriptionConsumer.accept(subscription);
                }
                catch (Throwable ex) {
                    subscription.cancel();
                    this.onError(ex);
                }
            } else {
                subscription.request(Long.MAX_VALUE);
            }
        }
    }

    @Override
    public void onComplete() {
        if (this.completeConsumer != null) {
            try {
                this.completeConsumer.run();
            }
            catch (Throwable t) {
                this.onError(t);
            }
        }
    }

    @Override
    public void onError(Throwable ex) {
        if (this.errorConsumer != null) {
            this.errorConsumer.accept(ex);
        }
    }

    @Override
    public void onNext(T x) {
        try {
            if (this.consumer != null) {
                this.consumer.accept(x);
            }
        }
        catch (Throwable t) {
            this.subscription.cancel();
            this.onError(t);
        }
    }
}

