/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Flow;

final class SingleFromPublisher<T>
extends CompletionSingle<T> {
    private final Flow.Publisher<T> source;

    SingleFromPublisher(Flow.Publisher<T> source) {
        this.source = source;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new SingleSubscriber<T>(subscriber));
    }

    static final class SingleSubscriber<T>
    implements Flow.Subscriber<T> {
        private final Flow.Subscriber<? super T> downstream;
        private Flow.Subscription upstream;
        private T item;

        SingleSubscriber(Flow.Subscriber<? super T> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(subscription);
        }

        @Override
        public void onNext(T item) {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                if (this.item != null) {
                    this.upstream.cancel();
                    this.onError(new IllegalStateException("The source produced more than one item."));
                } else {
                    this.item = item;
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.item = null;
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                T v = this.item;
                if (v != null) {
                    this.item = null;
                    this.downstream.onNext(v);
                }
                this.downstream.onComplete();
            }
        }
    }
}

