/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.EmptySubscription;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.Flow;

final class MultiLimitPublisher<T>
implements Multi<T> {
    private final Multi<T> source;
    private final long limit;

    MultiLimitPublisher(Multi<T> source, long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("limit is negative");
        }
        this.source = source;
        this.limit = limit;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        this.source.subscribe(new LimitSubscriber<T>(subscriber, this.limit));
    }

    static final class LimitSubscriber<T>
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private long remaining;
        private Flow.Subscription upstream;

        LimitSubscriber(Flow.Subscriber<? super T> downstream, long remaining) {
            this.downstream = downstream;
            this.remaining = remaining;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            if (this.remaining == 0L) {
                subscription.cancel();
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream.onSubscribe(EmptySubscription.INSTANCE);
                this.downstream.onComplete();
            } else {
                this.upstream = subscription;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T item) {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                long r;
                this.remaining = r = this.remaining - 1L;
                this.downstream.onNext(item);
                if (r == 0L) {
                    s.cancel();
                    this.upstream = SubscriptionHelper.CANCELED;
                    this.downstream.onComplete();
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELED;
        }
    }
}

