/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

final class MultiOnErrorResumeWith<T>
implements Multi<T> {
    private final Multi<T> source;
    private final Function<? super Throwable, ? extends Flow.Publisher<? extends T>> fallbackFunction;

    MultiOnErrorResumeWith(Multi<T> source, Function<? super Throwable, ? extends Flow.Publisher<? extends T>> fallbackFunction) {
        this.source = source;
        this.fallbackFunction = fallbackFunction;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new OnErrorResumeWithSubscriber<T>(subscriber, this.fallbackFunction));
    }

    static final class OnErrorResumeWithSubscriber<T>
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private final Function<? super Throwable, ? extends Flow.Publisher<? extends T>> fallbackFunction;
        private Flow.Subscription upstream;
        private long received;
        private final AtomicLong requested;
        private final FallbackSubscriber<T> fallbackSubscriber;

        OnErrorResumeWithSubscriber(Flow.Subscriber<? super T> downstream, Function<? super Throwable, ? extends Flow.Publisher<? extends T>> fallbackFunction) {
            this.downstream = downstream;
            this.fallbackFunction = fallbackFunction;
            this.requested = new AtomicLong();
            this.fallbackSubscriber = new FallbackSubscriber<T>(downstream, this.requested);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(T item) {
            ++this.received;
            this.downstream.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            Flow.Publisher<T> publisher;
            this.upstream = SubscriptionHelper.CANCELED;
            long p = this.received;
            if (p != 0L) {
                SubscriptionHelper.produced(this.requested, p);
            }
            try {
                publisher = Objects.requireNonNull(this.fallbackFunction.apply(throwable), "The fallback function returned a null Flow.Publisher");
            }
            catch (Throwable ex) {
                if (ex != throwable) {
                    ex.addSuppressed(throwable);
                }
                this.downstream.onError(ex);
                return;
            }
            publisher.subscribe(this.fallbackSubscriber);
        }

        @Override
        public void onComplete() {
            this.upstream = SubscriptionHelper.CANCELED;
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.downstream.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden"));
            } else {
                SubscriptionHelper.deferredRequest(this.fallbackSubscriber, this.requested, n);
                this.upstream.request(n);
            }
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            SubscriptionHelper.cancel(this.fallbackSubscriber);
        }

        static final class FallbackSubscriber<T>
        extends AtomicReference<Flow.Subscription>
        implements Flow.Subscriber<T> {
            private final Flow.Subscriber<? super T> downstream;
            private final AtomicLong requested;

            FallbackSubscriber(Flow.Subscriber<? super T> downstream, AtomicLong requested) {
                this.downstream = downstream;
                this.requested = requested;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                SubscriptionHelper.deferredSetOnce(this, this.requested, subscription);
            }

            @Override
            public void onNext(T item) {
                this.downstream.onNext(item);
            }

            @Override
            public void onError(Throwable throwable) {
                this.downstream.onError(throwable);
            }

            @Override
            public void onComplete() {
                this.downstream.onComplete();
            }
        }
    }
}

