/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

enum TerminatedFuture implements Future<Object>
{
    FINISHED,
    CANCELED;


    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this == CANCELED;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public Object get() {
        if (this == CANCELED) {
            throw new CancellationException();
        }
        return null;
    }

    @Override
    public Object get(long timeout, TimeUnit unit) {
        if (this == CANCELED) {
            throw new CancellationException();
        }
        return null;
    }

    public static void setFuture(AtomicReference<Future<?>> field, Future<?> f) {
        do {
            Future<?> current;
            if ((current = field.get()) == CANCELED) {
                f.cancel(true);
                return;
            }
            if (current == null) continue;
            return;
        } while (!field.compareAndSet(null, f));
    }

    public static void cancel(AtomicReference<Future<?>> field) {
        Future<?> current;
        do {
            if ((current = field.get()) != FINISHED && current != CANCELED) continue;
            return;
        } while (!field.compareAndSet(current, CANCELED));
        if (current != null) {
            current.cancel(true);
        }
    }
}

