/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Flow;

final class MultiFirstPublisher<T>
extends CompletionSingle<T> {
    private final Multi<T> source;

    MultiFirstPublisher(Multi<T> source) {
        this.source = source;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new FirstSubscriber<T>(subscriber));
    }

    static final class FirstSubscriber<T>
    implements Flow.Subscriber<T> {
        private final Flow.Subscriber<? super T> downstream;
        private Flow.Subscription upstream;

        FirstSubscriber(Flow.Subscriber<? super T> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(subscription);
        }

        @Override
        public void onNext(T item) {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                s.cancel();
                this.downstream.onNext(item);
                this.onComplete();
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream.onComplete();
            }
        }
    }
}

