/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.Objects;
import java.util.function.Consumer;

public class StreamValidationUtils {
    private StreamValidationUtils() {
    }

    static boolean checkRequestParam(long requestParam, Consumer<? super IllegalArgumentException> onExceeded) {
        if (requestParam <= 0L) {
            if (Objects.nonNull(onExceeded)) {
                onExceeded.accept(StreamValidationUtils.createNonPositiveRequestException(requestParam));
            }
            return false;
        }
        return true;
    }

    static IllegalArgumentException createNonPositiveRequestException(long n) {
        return new IllegalArgumentException(String.format("Non-positive subscription request %d, rule 3.9", n));
    }

    static RuntimeException createOnlyOneSubscriberAllowedException() {
        return new IllegalStateException("This Publisher supports only one Subscriber");
    }
}

