/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.MultiTappedPublisher;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

class MultiLoggingPublisher<T>
implements Multi<T> {
    private static final Logger LOGGER = Logger.getLogger(MultiLoggingPublisher.class.getName());
    private static final AtomicLong LOG_ID = new AtomicLong();
    private final String caller;
    private final String loggerName;
    private final String methodName;
    private final Multi<T> source;
    private final Level level;

    MultiLoggingPublisher(Multi<T> source, Level level, String loggerName) {
        Objects.requireNonNull(loggerName);
        this.source = source;
        this.level = level;
        this.loggerName = loggerName;
        this.caller = Multi.class.getName();
        this.methodName = "log()";
    }

    MultiLoggingPublisher(Multi<T> source, Level level, boolean trace) {
        Optional<StackWalker.StackFrame> frm;
        this.source = source;
        this.level = level;
        if (trace && (frm = this.findCaller()).isPresent()) {
            this.caller = frm.map(StackWalker.StackFrame::getClassName).orElse(Multi.class.getName());
            String fileName = frm.map((? super T f) -> f.getFileName() + ":" + f.getLineNumber()).orElse("");
            this.methodName = frm.map(StackWalker.StackFrame::getMethodName).orElse("log") + "(" + fileName + ")";
            this.loggerName = this.caller + "." + this.methodName;
            return;
        }
        this.caller = Multi.class.getName();
        this.methodName = "log()";
        this.loggerName = Multi.class.getSimpleName() + ".log(" + LOG_ID.incrementAndGet() + ")";
    }

    private Optional<StackWalker.StackFrame> findCaller() {
        return StackWalker.getInstance().walk(frmStream -> frmStream.limit(4L).skip(3L).findFirst());
    }

    private void log(Supplier<String> msgSupplier) {
        if (!LOGGER.isLoggable(this.level)) {
            return;
        }
        LogRecord record = new LogRecord(this.level, msgSupplier.get());
        record.setSourceClassName(this.caller);
        record.setSourceMethodName(this.methodName);
        record.setLoggerName(this.loggerName);
        LOGGER.log(record);
    }

    private void logCancel() {
        this.log(() -> " \u21d7 cancel()");
    }

    private void logOnComplete() {
        this.log(() -> " \u21d8 onComplete()");
    }

    private void logRequest(long n) {
        this.log(() -> " \u21d7 request(" + (Serializable)(n == Long.MAX_VALUE ? "Long.MAX_VALUE" : Long.valueOf(n)) + ")");
    }

    private void logOnError(Throwable throwable) {
        this.log(() -> " \u21d8 onError(" + throwable + ")");
    }

    private void logOnSubscribe(Flow.Subscription subscription) {
        this.log(() -> " \u21d8 onSubscribe(...)");
    }

    private void logOnNext(T item) {
        this.log(() -> " \u21d8 onNext(" + item + ")");
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        this.source.subscribe(new MultiTappedPublisher.MultiTappedSubscriber<Object>(subscriber, this::logOnSubscribe, this::logOnNext, this::logOnError, this::logOnComplete, this::logRequest, this::logCancel));
    }
}

