/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Flow;
import java.util.function.Predicate;

final class MultiDropWhilePublisher<T>
implements Multi<T> {
    private final Multi<T> source;
    private final Predicate<? super T> predicate;

    MultiDropWhilePublisher(Multi<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new DropWhileSubscriber<T>(subscriber, this.predicate));
    }

    static final class DropWhileSubscriber<T>
    implements Flow.Subscriber<T> {
        private final Flow.Subscriber<? super T> downstream;
        private final Predicate<? super T> predicate;
        private Flow.Subscription upstream;
        private boolean passThrough;

        DropWhileSubscriber(Flow.Subscriber<? super T> downstream, Predicate<? super T> predicate) {
            this.downstream = downstream;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(subscription);
        }

        @Override
        public void onNext(T item) {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                if (this.passThrough) {
                    this.downstream.onNext(item);
                } else {
                    boolean b;
                    try {
                        b = this.predicate.test(item);
                    }
                    catch (Throwable ex) {
                        this.upstream.cancel();
                        this.onError(ex);
                        return;
                    }
                    if (!b) {
                        this.passThrough = true;
                        this.downstream.onNext(item);
                    } else {
                        this.upstream.request(1L);
                    }
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream.onComplete();
            }
        }
    }
}

