/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.LazyValue;
import io.helidon.common.reactive.CompletionAwaitable;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.SingleToFuture;
import java.util.concurrent.CompletableFuture;

public abstract class CompletionSingle<T>
extends CompletionAwaitable<T>
implements Single<T> {
    private final CompletableFuture<Void> cancelFuture = new CompletableFuture();

    protected CompletionSingle() {
        LazyValue lazyStage = LazyValue.create(this::toNullableStage);
        this.setOriginalStage(() -> lazyStage.get());
    }

    protected CompletableFuture<T> toNullableStage() {
        SingleToFuture subscriber = new SingleToFuture(this, true);
        this.subscribe(subscriber);
        return subscriber;
    }

    @Override
    public Single<T> onCancel(Runnable onCancel) {
        this.cancelFuture.thenRun(onCancel);
        return Single.super.onCancel(onCancel);
    }

    @Override
    public Single<T> cancel() {
        Single single = Single.super.cancel();
        this.cancelFuture.complete(null);
        return single;
    }
}

