/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.EmptySubscription;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.MultiFromInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntSupplier;

class MultiFromBlockingInputStream
extends MultiFromInputStream {
    private final InputStream inputStream;
    private IntSupplier bufferSizeSupplier;
    private final ExecutorService executorService;

    MultiFromBlockingInputStream(InputStream inputStream, int bufferSize, ExecutorService executorService) {
        super(inputStream, bufferSize);
        this.inputStream = inputStream;
        this.bufferSizeSupplier = () -> bufferSize;
        this.executorService = executorService;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        try {
            this.inputStream.available();
        }
        catch (IOException e) {
            subscriber.onSubscribe(EmptySubscription.INSTANCE);
            subscriber.onError(e);
            return;
        }
        InputStreamSubscription subscription = new InputStreamSubscription(subscriber, this.inputStream, this.bufferSizeSupplier.getAsInt(), this.executorService);
        subscriber.onSubscribe(subscription);
    }

    @Override
    public Multi<ByteBuffer> withByteBufferSize(int bufferSize) {
        this.bufferSizeSupplier = () -> bufferSize;
        return this;
    }

    static final class InputStreamSubscription
    extends MultiFromInputStream.InputStreamSubscription {
        private final ExecutorService executorService;
        private final LinkedBlockingQueue<Runnable> submitQueue = new LinkedBlockingQueue();
        private final AtomicBoolean draining = new AtomicBoolean(false);

        InputStreamSubscription(Flow.Subscriber<? super ByteBuffer> downstream, InputStream inputStream, int bufferSize, ExecutorService executorService) {
            super(downstream, inputStream, bufferSize);
            this.executorService = executorService;
        }

        @Override
        protected void trySubmit(long n) {
            this.submitQueue.add(() -> {
                this.submit(n);
                this.drainSubmitQueue();
            });
            this.drainSubmitQueue();
        }

        private void drainSubmitQueue() {
            if (!this.draining.getAndSet(true)) {
                try {
                    Runnable job = this.submitQueue.poll();
                    if (job != null) {
                        this.executorService.submit(job);
                    }
                }
                finally {
                    this.draining.set(false);
                }
            }
        }
    }
}

